<?php

namespace Modules\Vehicle\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleBrand\VehicleBrandStorRequest;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleBrand\VehicleBrandUpdateRequest;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleBrandType;
use Modules\Vehicle\app\Models\VehicleType;

class VehicleBrandController extends Controller
{
    public function index()
    {
        $VehicleBrands = VehicleBrand::all();
        $VehicleTypes = VehicleType::where('state', 1)->get();
//        $query = Education::when(!is_null(Request()->q),function ($query){
//            return $query->where('title','LIKE','%'.Request()->q."%")
//                ->orWhere('id','LIKE','%'.Request()->q."%");
//        })
//            ->latest('id');

        return view('vehicle::Dashboard.Frest.VehicleBrand.index', compact('VehicleBrands', 'VehicleTypes'));
    }

    public function create()
    {
        $VehicleTypes = VehicleType::where('state', 1)->get();
        return view('vehicle::Dashboard.Frest.VehicleBrand.create', compact('VehicleTypes'));
    }

    public function store(VehicleBrandStorRequest $request)
    {

        $brandCreated = VehicleBrand::firstOrcreate([
            'title' => $request->title,
            'state' => $request->state,
        ]);

        $brandCreated->types()->sync($request->types, false);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleBrand.index');
    }

    public function show($id)
    {
//        return view('vehicle::show');
    }

    public function edit($id)
    {
        $brandTypes = VehicleBrandType::where('vehicle_brand_id', $id)->pluck('vehicle_type_id')->toArray();
        $VehicleTypes = VehicleType::where('state', 1)->get();
        $VehicleBrand = VehicleBrand::where('id', $id)->first();
        return view('vehicle::Dashboard.Frest.VehicleBrand.edit', compact('VehicleBrand', 'VehicleTypes', 'brandTypes'));
    }

    public function update(VehicleBrandUpdateRequest $request, VehicleBrand $VehicleBrand)
    {
        $VehicleBrand->title = $request->title;
        $VehicleBrand->state = $request->state;
        $VehicleBrand->update();

        $deleteVehicleBrand = VehicleBrandType::where('vehicle_brand_id', $VehicleBrand->id)->delete();
        $VehicleBrand->types()->sync($request->types, false);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleBrand.index');
    }

    public function destroy(VehicleBrand $VehicleBrand)
    {
        $VehicleBrand->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            VehicleBrand::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            VehicleBrand::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            VehicleBrand::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
