<?php

namespace Modules\Vehicle\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleCategory\VehicleCategoryStorRequest;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleCategory\VehicleCategoryUpdateRequest;
use Modules\Vehicle\app\Models\VehicleCategory;

class VehicleCategoryController extends Controller
{

    public function index()
    {
        $VehicleCategories = VehicleCategory::all();

        return view('vehicle::Dashboard.Frest.VehicleCategory.index', compact('VehicleCategories'));
    }

    public function create()
    {
        return view('vehicle::Dashboard.Frest.VehicleCategory.create');
    }

    public function store(VehicleCategoryStorRequest $request)
    {
        $VehicleCategory = VehicleCategory::create([
            'title' => $request->title,
            'membership_fee' => str_replace(',', '',$request->membership_fee),
            'state' => $request->state,
            'type' => $request->type,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleCategory.index');
    }

    public function show($id)
    {
        return view('vehicle::show');
    }

    public function edit($id)
    {
        $VehicleCategory = VehicleCategory::where('id', $id)->first();
        return view('vehicle::Dashboard.Frest.VehicleCategory.edit', compact('VehicleCategory'));
    }

    public function update(VehicleCategoryUpdateRequest $request, VehicleCategory $VehicleCategory)
    {
//        dd($request->all());
        $VehicleCategory->title = $request->title;
        $VehicleCategory->membership_fee = str_replace(',', '',$request->membership_fee);
        $VehicleCategory->state = $request->state;
        $VehicleCategory->type = $request->type;
        $VehicleCategory->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleCategory.index');
    }

    public function destroy(VehicleCategory $VehicleCategory)
    {
        $VehicleCategory->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            VehicleCategory::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            VehicleCategory::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            VehicleCategory::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
