<?php

namespace Modules\Vehicle\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\News\app\Models\News;
use Modules\User\app\Models\Profile;
use Modules\User\app\Models\User;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\Vehicle\VehicleStorRequest;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\Vehicle\VehicleUpdateRequest;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleCategory;
use Modules\Vehicle\app\Models\VehicleGallery;
use Modules\Vehicle\app\Models\Vehicles;
use Modules\Vehicle\app\Models\VehicleType;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Carbon\Carbon;
use Morilog\Jalali\Jalalian;
//use Vtiful\Kernel\Excel;
use Maatwebsite\Excel\Facades\Excel;

class VehicleController extends Controller
{
    public function index()
    {
//        $Vehicles = Vehicles::with('galleries', 'user.profile', 'type', 'brand', 'category')->get();
        $query = Vehicles::
            when(Request()->model_year != null,function ($query){
                $query->where('model_year',Request()->model_year);
            })->
            when(!is_null(Request()->state),function ($query){
                return $query->whereIn('state',Request()->state);
            })
            ->when(!is_null(Request()->categories),function ($query){
                return $query->whereIn('category_id',Request()->categories);
            })
            ->when(!is_null(Request()->brands),function ($query){
                return $query->whereIn('brand_id',Request()->brands);
            })
            ->when(!is_null(Request()->types),function ($query){
                return $query->whereIn('type_id',Request()->types);
            })
            ->when(!is_null(Request()->users),function ($query){
                return $query->whereIn('user_id',Request()->users);
            })
            ->with('galleries', 'user.profile', 'type', 'brand', 'category')
            ->latest('id');

//        if(isset($_GET['print'])){
//            $news = $query->limit(200)->get();
//            return view('template.print.news' , compact('news'));
//        }

//        if(isset($_GET['pdf'])){
//            $news = $query->limit(200)->get();
//            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
//            $pdf = Pdf::loadView('vehicle::print.vehicles', ['vehicles' => $news]);
//            return $pdf->download('news.pdf');
//        }

        if(isset($_GET['pdf'])){
            $vehicles = $query->limit(200)->get();
            Pdf::setOption(['dpi' => 150, 'defaultFont' => 'sans-serif']);
            $pdf = Pdf::loadView('vehicle::print.vehicles', ['Vehicles' => $vehicles]);
            return $pdf->download('vehicles.pdf');
        }

//        if (isset($_GET['excel'])) {
//            $items = $query->latest()->get();
//            return Excel::download(new NewsExport($items),'news.xlsx');
//        }

        $Vehicles = $query->paginate(15);
        $categories = VehicleCategory::all();
        $brands = VehicleBrand::all();
        $types = VehicleType::all();
        $users = User::has('profile')->with('profile')->get();
        return view('vehicle::Dashboard.Frest.Vehicle.index', compact('Vehicles', 'categories', 'brands', 'types', 'users'));
    }

    public function create()
    {
        $categories = VehicleCategory::where('state', 1)->get();
        $users = User::with('profile')->where('state', 'accepted')->get();
        $brands = VehicleBrand::where('state', 1)->get();
        $types = VehicleType::where('state', 1)->get();
        return view('vehicle::Dashboard.Frest.Vehicle.create', compact('categories', 'users', 'brands', 'types'));
    }

    public function store(VehicleStorRequest $request)
    {

        if ($request->filled('motor_card_number')) {
            $existingVehicle = Vehicles::where('motor_card_number', $request->motor_card_number)->first();
            if ($existingVehicle)
            {
                session::flash('error','پلاک موتور تکراری است');
                return redirect()->route('admin.Vehicle.create');
            }
        }
        else
        {
            $existingVehicle = Vehicles::where('car_first_section_card_number', $request->plate_part4)
                ->where('car_second_section_card_number', $request->plate_part3)
                ->where('car_third_section_card_number', $request->plate_part2)
                ->where('car_fourth_section_card_number', $request->plate_part1)
                ->first();

            if ($existingVehicle)
            {
                session::flash('error','پلاک اتوموبیل تکراری است');
                return redirect()->route('admin.Vehicle.create');
            }
        }

        $dateTime = Carbon::createFromFormat('Y-m-d H:i', $request->insurance_date);
        $dateOnly = $dateTime->format('Y-m-d');
        $jalalian = Jalalian::fromFormat('Y-m-d', $dateOnly);
        $gregorianDate = $jalalian->toCarbon()->format('Y-m-d');

        $vehicle_card = File::uploadImage($request->vehicle_card, 'cars', $width = null, $height = null, $disk = 'secret');
        $insurance = File::imageUpload($request->insurance, 'cars', $width = null, $height = null, $disk = 'secret');
        $technical_examination = File::imageUpload($request->technical_examination, 'cars', $width = null, $height = null, $disk = 'secret');
        $vehicle_front = File::imageUpload($request->vehicle_front, 'cars', $width = null, $height = null, $disk = 'secret');
        $vehicle_back = File::imageUpload($request->vehicle_back, 'cars', $width = null, $height = null, $disk = 'secret');
        $vehicle_right = File::imageUpload($request->vehicle_right, 'cars', $width = null, $height = null, $disk = 'secret');
        $vehicle_left = File::imageUpload($request->vehicle_left, 'cars', $width = null, $height = null, $disk = 'secret');

        $createVehicle = Vehicles::firstOrcreate([
            'car_first_section_card_number' => $request->plate_part4,
            'car_second_section_card_number' => $request->plate_part3,
            'car_third_section_card_number' => $request->plate_part2,
            'car_fourth_section_card_number' => $request->plate_part1,
            'motor_card_number' => $request->motor_pelak,
            'state' => 'accepted',
            'model_year' => $request->model_year,
            'category_id' => $request->category_id,
            'brand_id' => $request->brand_id,
            'user_id' => $request->user_id,
            'type_id' => $request->type_id,
            'insurance_date' =>$gregorianDate,
            'color' =>$request->color,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'vehicle_card',
            'path_file' => $vehicle_card,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'insurance',
            'path_file' => $insurance,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'technical_examination',
            'path_file' => $technical_examination,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'vehicle_front',
            'path_file' => $vehicle_front,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'vehicle_back',
            'path_file' => $vehicle_back,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'vehicle_right',
            'path_file' => $vehicle_right,
            'vehicle_id' => $createVehicle->id,
        ]);

        $createVehicleGallery = VehicleGallery::create([
            'name' => 'vehicle_left',
            'path_file' => $vehicle_left,
            'vehicle_id' => $createVehicle->id,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.Vehicle.index');
    }

    public function show($id)
    {
        $gallery = VehicleGallery::find($id);
        return Storage::disk('secret')->response($gallery->path_file);
    }

    public function edit($id)
    {
        $Vehicle = Vehicles::with('galleries', 'user.profile', 'type','notes' ,'brand', 'category')->where('id', $id)->first();
        $categories = VehicleCategory::where('state', 1)->get();
        $users = User::with('profile')->where('state', 'accepted')->get();
        $brands = VehicleBrand::where('state', 1)->get();
        $types = VehicleType::where('state', 1)->get();
//        dd($Vehicle);
//         return Storage::disk('secret')->response('cars/ccoOxMy89Js1vneiK79a5PdzqgqY1dZGTTOq6U50.jpg');
//        return Storage::disk('secret')->download('cars/ccoOxMy89Js1vneiK79a5PdzqgqY1dZGTTOq6U50.jpg');
//        echo $ali = Storage::disk('secret')->download('cars/ccoOxMy89Js1vneiK79a5PdzqgqY1dZGTTOq6U50.jpg');
        return view('vehicle::Dashboard.Frest.Vehicle.edit', compact('categories', 'users', 'brands', 'types', 'Vehicle'));
    }

    public function update(VehicleUpdateRequest $request, $id)
    {
//        dd($request->all());
        $old_vehicle = Vehicles::find($id);
        $old_vehicle_galleries = VehicleGallery::where('vehicle_id', $id)->get();

        $vehicle_card = $old_vehicle_galleries[0]->path_file;
        $insurance = $old_vehicle_galleries[1]->path_file;
        $technical_examination = $old_vehicle_galleries[2]->path_file;
        $vehicle_front = $old_vehicle_galleries[3]->path_file;
        $vehicle_back = $old_vehicle_galleries[4]->path_file;
        $vehicle_right = $old_vehicle_galleries[5]->path_file;
        $vehicle_left = $old_vehicle_galleries[6]->path_file;


        if (isset($request->vehicle_card))
        {
            $vehicle_card_delete = File::delete($vehicle_card, $disk = 'secret');
            $vehicle_card = File::uploadImage($request->vehicle_card, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_card')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_card',
                'path_file' => $vehicle_card,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->insurance))
        {
            $insurance_delete = File::delete($insurance, $disk = 'secret');
            $insurance = File::uploadImage($request->insurance, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'insurance')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'insurance',
                'path_file' => $insurance,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->technical_examination))
        {
            $technical_examination_delete = File::delete($technical_examination, $disk = 'secret');
            $technical_examination = File::uploadImage($request->technical_examination, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'technical_examination')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'technical_examination',
                'path_file' => $technical_examination,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_front))
        {
            $vehicle_front_delete = File::delete($vehicle_front, $disk = 'secret');
            $vehicle_front = File::uploadImage($request->vehicle_front, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_front')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_front',
                'path_file' => $vehicle_front,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_back))
        {
            $vehicle_back_delete = File::delete($vehicle_back, $disk = 'secret');
            $vehicle_back = File::uploadImage($request->vehicle_back, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_back')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_back',
                'path_file' => $vehicle_back,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_right))
        {
            $vehicle_right_delete = File::delete($vehicle_right, $disk = 'secret');
            $vehicle_right = File::uploadImage($request->vehicle_right, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_right')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_right',
                'path_file' => $vehicle_right,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }
        if (isset($request->vehicle_left))
        {
            $vehicle_left_delete = File::delete($vehicle_left, $disk = 'secret');
            $vehicle_left = File::uploadImage($request->vehicle_left, 'cars', $width = null, $height = null, $disk = 'secret');
            $updateVehicleGallery = VehicleGallery::where('name', 'vehicle_left')->where('vehicle_id', $old_vehicle->id)->update([
                'name' => 'vehicle_left',
                'path_file' => $vehicle_left,
                'vehicle_id' => $old_vehicle->id,
            ]);
        }

        $dateTime = Carbon::createFromFormat('Y-m-d H:i', $request->insurance_date);
        $dateOnly = $dateTime->format('Y-m-d');
        $jalalian = Jalalian::fromFormat('Y-m-d', $dateOnly);
        $gregorianDate = $jalalian->toCarbon()->format('Y-m-d');

        $UpdateVehicle = Vehicles::where('id', $id)->update([
            'car_first_section_card_number' => $request->plate_part4,
            'car_second_section_card_number' => $request->plate_part3,
            'car_third_section_card_number' => $request->plate_part2,
            'car_fourth_section_card_number' => $request->plate_part1,
            'motor_card_number' => $request->motor_pelak,
            'state' => 'accepted',
            'model_year' => $request->model_year,
            'category_id' => $request->category_id,
            'brand_id' => $request->brand_id,
            'user_id' => $request->user_id,
            'type_id' => $request->type_id,
            'color' => $request->color,
            'insurance_date' => $gregorianDate,
        ]);

        $Vehicle = Vehicles::find($id);

        $Vehicle->notes()->create(
            [
                'note' => "وسیله نقلیه توسط ادمین تایید شد",
                'admin_id' => Auth::user()->id,
                'user_id' => $request->user_id,
                'state' => '0',
                'read' => '0',
            ]);
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.Vehicle.index');
    }

    public function destroy(Vehicles $vehicles)
    {
        $vehicles->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Vehicles::whereIn('id',$items)->delete();
        }
//        if (isset($_GET['unPublish']))
//        {
////            $this->authorize('product.edit');
//            Vehicles::whereIn('id',$items)->update([
//                'state' => 0
//            ]);
//        }
//        if(isset($_GET['publish']))
//        {
////            $this->authorize('product.edit');
//            Vehicles::whereIn('id',$items)->update([
//                'state' => 1
//            ]);
//        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
    public function createNote($id, Request $request)
    {
        $Vehicle = Vehicles::find($id);

        $Vehicle->state = 'rejected';
        $Vehicle->save();

        $Vehicle->notes()->create(
            [
                'note' => $request->title,
                'admin_id' => Auth::user()->id,
                'user_id' => $Vehicle->user_id,
                'state' => '0',
                'read' => '0',
            ]);
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.Vehicle.index');
    }
}
