<?php

namespace Modules\Vehicle\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleBrand\VehicleBrandStorRequest;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleType\VehicleTypeStorRequest;
use Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleType\VehicleTypeUpdateRequest;
use Modules\Vehicle\app\Models\VehicleBrand;
use Modules\Vehicle\app\Models\VehicleBrandType;
use Modules\Vehicle\app\Models\VehicleType;

class VehicleTypeController extends Controller
{
    public function index()
    {
        $brandTypes = VehicleBrandType::with('brand', 'type')->get();
        $VehicleBrands = VehicleBrand::where('state', 1)->get();
//        $selectedBrand = VehicleBrandType::find($id)->vehicle_brand_id;
//        $VehicleType = VehicleType::where('id', VehicleBrandType::find($id)->vehicle_type_id)->first();
//        $VehicleTypes = VehicleType::all();
//        $query = Education::when(!is_null(Request()->q),function ($query){
//            return $query->where('title','LIKE','%'.Request()->q."%")
//                ->orWhere('id','LIKE','%'.Request()->q."%");
//        })
//            ->latest('id');

        return view('vehicle::Dashboard.Frest.VehicleType.index', compact('brandTypes', 'VehicleBrands'));
    }

    public function create()
    {
        $VehicleBrands = VehicleBrand::where('state', 1)->get();
        return view('vehicle::Dashboard.Frest.VehicleType.create', compact('VehicleBrands'));
    }

    public function store(VehicleTypeStorRequest $request)
    {
         $typeCreated = VehicleType::firstOrcreate([
             'title' => $request->title,
             'state' => $request->state,
         ]);

         if($request->brand_id != null){
             $typeCreated->brands()->sync([$request->brand_id], false);
         }
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleType.index');
    }

    public function show($id)
    {
        return view('vehicle::show');
    }

    public function edit($id)
    {
        $VehicleBrands = VehicleBrand::where('state', 1)->get();
        $selectedBrand = VehicleBrandType::find($id)->vehicle_brand_id;
        $VehicleType = VehicleType::where('id', VehicleBrandType::find($id)->vehicle_type_id)->first();
        return view('vehicle::Dashboard.Frest.VehicleType.edit', compact('VehicleBrands', 'selectedBrand', 'VehicleType'));
    }

    public function update(VehicleTypeUpdateRequest $request, $id)
    {
        $vehicleType = VehicleType::find($id);
        $vehicleType->title = $request->title;
        $vehicleType->state = $request->state;
        $vehicleType->update();
        $vehicleType->brands()->sync([$request->brand_id], false);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.VehicleType.index');
    }

    public function destroy(VehicleType $vehicleType)
    {
        $vehicleType->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            VehicleType::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            VehicleType::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            VehicleType::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
