<?php

namespace Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleCategory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VehicleCategoryUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $vehicle_categoryId = $this->route('VehicleCategory')->id;
        return [
            'title' => [
                'required',
                Rule::unique('vehicle_categories', 'title')->ignore($vehicle_categoryId),
            ],
//            'name' => [
//                'required',
//                Rule::unique('vehicle_categories', 'name')->ignore($educationId)->whereNull('deleted_at'),
//            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
