<?php

namespace Modules\Vehicle\app\Http\Requests\Dashboard\Frest\VehicleType;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VehicleTypeUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $vehicle_typeId = $this->route('VehicleType');
        return [
            'title' => [
                'required',
                Rule::unique('vehicle_types', 'title')->ignore($vehicle_typeId),
            ],
//            'name' => [
//                'required',
//                Rule::unique('vehicle_categories', 'name')->ignore($educationId)->whereNull('deleted_at'),
//            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
