<?php

namespace Modules\Vehicle\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Vehicle\Database\factories\VehicleBrandFactory;

class VehicleBrand extends Model
{
    use HasFactory;

    protected $table = 'vehicle_brands';

    protected $fillable = [
        'title',
        'state'
    ];

    public function brandTypes()
    {
        return $this->hasMany(VehicleBrandType::class, 'vehicle_brand_id');
    }

    public function types()
    {
        return $this->belongsToMany(VehicleType::class, 'brand_types');
    }
}
