<?php

namespace Modules\Vehicle\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Vehicle\Database\factories\VehicleGalleryFactory;

class VehicleBrandType extends Model
{
    use HasFactory;

    protected $table = 'brand_types';

    protected $fillable = [
        'vehicle_brand_id',
        'vehicle_type_id',
    ];

    public function brand()
    {
        return $this->belongsTo(VehicleBrand::class, 'vehicle_brand_id');
    }

    public function type()
    {
        return $this->belongsTo(VehicleType::class, 'vehicle_type_id');
    }

}
