<?php

namespace Modules\Vehicle\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Storage;
use Modules\Vehicle\Database\factories\VehicleGalleryFactory;

class VehicleGallery extends Model
{
    use HasFactory;

    protected $table = 'vehicle_galleris';

    protected $fillable = [
        'name',
        'path_file',
        'vehicle_id',
    ];

    public function image_url()
    {
        return Storage::disk('secret')->response($this->path_file);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicles::class, 'vehicle_id');
    }
}
