<?php

namespace Modules\Vehicle\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Vehicle\Database\factories\VehicleTypeFactory;

class VehicleType extends Model
{
    use HasFactory;

    protected $table = 'vehicle_types';

    protected $fillable = [
        'title',
        'state',
    ];

    public function brandTypes()
    {
        return $this->hasMany(VehicleBrandType::class, 'vehicle_type_id');
    }

    public function brands()
    {
        return $this->belongsToMany(VehicleBrand::class, 'brand_types');
    }
}
