<?php

namespace Modules\Vehicle\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Note\app\Models\Note;
use Modules\User\app\Models\User;
use Modules\Vehicle\Database\factories\VehiclesFactory;

class Vehicles extends Model
{
    use HasFactory;

    protected $table = 'vehicles';

    protected $fillable = [
        'car_first_section_card_number',
        'car_second_section_card_number',
        'car_third_section_card_number',
        'car_fourth_section_card_number',
        'motor_card_number',
        'state',
        'model_year',
        'category_id',
        'brand_id',
        'user_id',
        'type_id',
        'insurance_date',
    ];

    public function category()
    {
        return $this->belongsTo(VehicleCategory::class, 'category_id');
    }

    public function brand()
    {
        return $this->belongsTo(VehicleBrand::class, 'brand_id');
    }

    public function type()
    {
        return $this->belongsTo(VehicleType::class, 'type_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function galleries()
    {
        return $this->hasMany(VehicleGallery::class, 'vehicle_id');
    }

    public function notes()
    {
        return $this->morphMany(Note::class, 'note','object_type','object_id');
    }
}
