<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->string('car_first_section_card_number')->nullable();
            $table->string('car_second_section_card_number')->nullable();
            $table->string('car_third_section_card_number')->nullable();
            $table->string('car_fourth_section_card_number')->nullable();

            $table->string('motor_card_number')->nullable();

            $table->string('state')->default('pending');
            $table->string('model_year');
            $table->string('insurance_date');

            $table->unsignedBigInteger('category_id')->unsigned();
            $table->foreign('category_id')->references('id')->on('vehicle_categories')->onDelete('cascade');

            $table->unsignedBigInteger('brand_id')->unsigned();
            $table->foreign('brand_id')->references('id')->on('vehicle_brands')->onDelete('cascade');

            $table->unsignedBigInteger('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('site_users')->onDelete('cascade');

            $table->unsignedBigInteger('type_id')->unsigned();
            $table->foreign('type_id')->references('id')->on('vehicle_types')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
