@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
    <link rel="stylesheet" href="{{ asset('modules/core/vendor/libs/tagify/tagify.css') }}" />
@endsection

@section('script')
    <script src="{{ asset('modules/core/editors/ckeditor/ckeditor.js') }}"></script>

    <script src="{{ asset('modules/core/vendor/libs/tagify/tagify.js') }}"></script>

    <script>
        var options = {
            filebrowserImageBrowseUrl: '/file-manager/ckeditor',
            filebrowserImageUploadUrl: '/file-manager/ckeditor',
            filebrowserBrowseUrl: '/file-manager/ckeditor',
            filebrowserUploadUrl: '/file-manager/ckeditor',

        };
        CKEDITOR.replace('body', options);
        $('#submit').on('keyup keypress', function(e) {
            var keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });
    </script>


    <script>
        const tag1 = document.querySelector("#tag");
        const tag = new Tagify(tag1, {
            {{--whitelist: [{!! \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],--}}
            dropdown: {
                classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                enabled: 0, // <- show suggestions on focus
                closeOnSelect: false // <- do not hide the suggestions dropdown once an item has been selected
            }
        });
    </script>
@endsection

@section('content')

    @include('core::components.file_set_to_editor')

    <div class="row">

        <div class="col 12">
            <x-modal id="add_note" size="sm" header="ثبت واکنش ">
                <form id="formData" action="{{ route('admin.Vehicle.create.note',$Vehicle->id) }}" method="post">
                    {{ csrf_field() }}

                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="title">متن واکنش</label>
                                        <textarea  id="title" name="title" class="form-control" required>

                                        </textarea>
                                        @if ($errors->has('title'))
                                            <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <center>
                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{ route('admin.VehicleCategory.index') }}" type="reset"
                               class="btn btn-label-secondary">انصراف</a>
                        </div>
                    </center>
                </form>
            </x-modal>
            <form action="" method="get">
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#add_note">
                    واکنش جدید
                </button>
            </form>
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="row">
                <div class="card mb-3 col-7 me-3">
                    <div class="card-header border-bottom primary-font">
                        <ul class="nav nav-tabs card-header-tabs" role="tablist">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                        aria-selected="true">
                                    وسیله نقلیه
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <form id="formData" enctype="multipart/form-data" action="{{ route('admin.Vehicle.update', $Vehicle->id) }}" method="post">
                            {{ csrf_field() }}
                            @method('patch')
                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="vehicle-type">نوع وسیله نقلیه</label>
                                                    <div class="position-relative">
                                                        <select id="vehicle-type" name="vehicle_type" class="form-select" onchange="showFields()" required>
                                                            @if($Vehicle->category->type == 0)
                                                                <option value="0" selected>اتوموبیل</option>
                                                                <option value="1" >موتور</option>
                                                            @else
                                                                <option value="0">اتوموبیل</option>
                                                                <option value="1" selected>موتور</option>
                                                            @endif
                                                        </select>
                                                        @if ($errors->has('vehicle_type'))
                                                            <div data-field="vehicle_type" class="text-danger">{{ $errors->first('vehicle_type') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="user_id">کاربر</label>
                                                    <div class="position-relative">
                                                        <select id="user_id" name="user_id" class="form-select" required>
                                                            @foreach($users as $user)
                                                                @if($user->id == $Vehicle->user->id)
                                                                    <option value="{{ $user->id }}" selected>{{ $user->profile->first_name . '-' . $user->mobile }}</option>
                                                                @else
                                                                    <option value="{{ $user->id }}">{{ $user->profile->first_name . '-' . $user->mobile }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->has('user_id'))
                                                            <div data-field="user_id" class="text-danger">{{ $errors->first('user_id') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="brand_id">برند</label>
                                                    <div class="position-relative">
                                                        <select id="brand_id" name="brand_id" class="form-select" required>
                                                            @foreach($brands as $brand)
                                                                @if($brand->id == $Vehicle->brand->id)
                                                                    <option value="{{ $brand->id }}" selected>{{ $brand->title }}</option>
                                                                @else
                                                                    <option value="{{ $brand->id }}">{{ $brand->title }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->has('brand_id'))
                                                            <div data-field="brand_id" class="text-danger">{{ $errors->first('brand_id') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="type_id">تیپ</label>
                                                    <div class="position-relative">
                                                        <select id="type_id" name="type_id" class="form-select" required>
                                                            @foreach($types as $type)
                                                                @if($type->id == $Vehicle->type->id)
                                                                    <option value="{{ $type->id }}" selected>{{ $type->title }}</option>
                                                                @else
                                                                    <option value="{{ $type->id }}">{{ $type->title }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->has('type_id'))
                                                            <div data-field="type_id" class="text-danger">{{ $errors->first('type_id') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="category_id">دسته بندی</label>
                                                    <div class="position-relative">
                                                        <select id="category_id" name="category_id" class="form-select" required>
                                                            @foreach($categories as $category)
                                                                @if($category->id == $Vehicle->category->id)
                                                                    <option value="{{ $category->id }}" selected>{{ $category->title }}</option>
                                                                @else
                                                                    <option value="{{ $category->id }}">{{ $category->title }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->has('category_id'))
                                                            <div data-field="category_id" class="text-danger">{{ $errors->first('category_id') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label for="flatpickr-datetime" class="form-label">تاریخ  نامه</label>
                                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="insurance_date" id="publish_up"  value="{{ Verta($Vehicle->insurance_date)->format('Y-m-d') }}" required/>
                                                    @if ($errors->has('insurance_date'))
                                                        <div data-field="insurance_date" class="text-danger">{{ $errors->first('insurance_date') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">کارت وسیله نقلیه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="vehicle_card"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[0]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('vehicle_card'))
                                                            <div data-field="vehicle_card" class="text-danger">{{ $errors->first('vehicle_card') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">بیمه نامه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="insurance"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[1]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('insurance'))
                                                            <div data-field="insurance" class="text-danger">{{ $errors->first('insurance') }}
                                                            </div>
                                                        @endif
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">معاینه فنی</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="technical_examination"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[2]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('technical_examination'))
                                                            <div data-field="technical_examination" class="text-danger">{{ $errors->first('technical_examination') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">جلوی وسیله نقلیه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="vehicle_front"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[3]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('vehicle_front'))
                                                            <div data-field="vehicle_front" class="text-danger">{{ $errors->first('vehicle_front') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">عقب وسیله نقلیه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="vehicle_back"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[4]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('vehicle_back'))
                                                            <div data-field="vehicle_back" class="text-danger">{{ $errors->first('vehicle_back') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-5">
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">راست وسیله نقلیه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="vehicle_right"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[5]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('vehicle_right'))
                                                            <div data-field="vehicle_right" class="text-danger">{{ $errors->first('vehicle_right') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">چپ وسیله نقلیه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="vehicle_left"
                                                               aria-label="Image" aria-describedby="button-image-2" >
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button">
                                                                <a href="{{  route('admin.Vehicle.show', $Vehicle->galleries[6]->id) }}">دیدن تصویر</a>
                                                            </button>
                                                        </div>
                                                        @if ($errors->has('vehicle_left'))
                                                            <div data-field="vehicle_left" class="text-danger">{{ $errors->first('vehicle_left') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-4">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="model_year">مدل وسیله نقلیه</label>
                                                    <input type="number" id="model_year" value="{{ $Vehicle->model_year }}" name="model_year" class="form-control" required>
                                                    @if ($errors->has('model_year'))
                                                        <div data-field="model_year" class="text-danger">{{ $errors->first('model_year') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="col-md-12">
                                                        <span>*</span>
                                                        <label class="form-label" for="color">رنگ</label>
                                                        <input type="text" id="color" name="color" class="form-control"
                                                               placeholder="رنگ" value={{ $Vehicle->color }}>
                                                    </div>
                                                    @if ($errors->has('color'))
                                                        <div data-field="color" class="text-danger">{{ $errors->first('color') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3" id="motor-field" style="display: none;">
                                                    <span>*</span>
                                                    <label class="form-label" for="motor_pelak">پلاک موتور</label>
                                                    @if(is_null($Vehicle->motor_card_number))
                                                        <input type="text" id="motor_pelak" name="motor_pelak" placeholder="پلاک موتور را وارد کنید" class="form-control">
                                                    @else
                                                        <input type="text" id="motor_pelak" name="motor_pelak" placeholder="پلاک موتور را وارد کنید" value="{{ $Vehicle->motor_card_number }}" class="form-control">
                                                    @endif
                                                    @if ($errors->has('motor_pelak'))
                                                        <div data-field="motor_pelak" class="text-danger">{{ $errors->first('motor_pelak') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3" id="car-fields" style="display: none;">
                                                    <span>*</span>
                                                    <label class="form-label" for="car-details">پلاک اتوموبیل</label>
                                                    <div class="card col-md-15" style="height: 25px; width: 210px">
                                                        <div id="car-fields" class="form-control">
                                                            @if(is_null($Vehicle->car_fourth_section_card_number))
                                                                <input type="text" id="plate-part1" name="plate_part1" placeholder="59" style="width: 50px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{2}" maxlength="2" title="دو عدد لازم است">
                                                                <input type="text" id="plate-part2" name="plate_part2" placeholder="572" style="width: 55px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{3}" maxlength="3" title="سه عدد لازم است">
                                                                <input type="text" id="plate-part3" name="plate_part3" placeholder="د" style="width: 50px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="[آ-ی]" maxlength="1" title="یک حرف فارسی لازم است">
                                                                <input type="text" id="plate-part4" name="plate_part4" placeholder="17" style="width: 55px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{2}" maxlength="2" title="دو عدد لازم است">
                                                            @else
                                                                <input type="text" id="plate-part1" value="{{ $Vehicle->car_fourth_section_card_number }}" name="plate_part1" placeholder="59" style="width: 50px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{2}" maxlength="2"  title="دو عدد لازم است">
                                                                <input type="text" id="plate-part2" value="{{ $Vehicle->car_third_section_card_number }}" name="plate_part2" placeholder="572" style="width: 50px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{3}" maxlength="3" title="سه عدد لازم است">
                                                                <input type="text" id="plate-part3" value="{{ $Vehicle->car_second_section_card_number }}" name="plate_part3" placeholder="د" style="width: 25px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="[آ-ی]" maxlength="1" title="یک حرف فارسی لازم است">
                                                                <input type="text" id="plate-part4" value="{{ $Vehicle->car_first_section_card_number }}" name="plate_part4" placeholder="17" style="width: 40px; height: 25px; padding: 5px; border: 1px ; border-radius: 3px;background-color: white; color: black;"
                                                                       pattern="\d{2}" maxlength="2" title="دو عدد لازم است">
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.VehicleCategory.index') }}" type="reset"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card mb-3 col-4">
                    <div class="card-header border-bottom primary-font">
                        <ul class="nav nav-tabs card-header-tabs" role="tablist">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                        aria-selected="true">
                                     واکنش ها
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
{{--                        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard(" نقلیه")}}</h5>--}}
                        <div class="table-responsive text-nowrap">
                                <table class="table table-sm">
                                    <thead>
                                    <tr>
                                        <th>نوشته</th>
                                        <th>وضعیت</th>
                                        <th>ایجاد</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($Vehicle->notes as $Vehicle)
                                        <tr>
                                            <td>
                                                {{ $Vehicle->note }}
                                            </td>

                                            <td>
                                                @if($Vehicle->read == 0)
                                                    <div>خوانده نشده</div>
                                                @else
                                                    <div>خوانده شده</div>
                                                @endif
                                            </td>

                                            <td>
                                                @if ($Vehicle->created_at != null)
                                                    {{ Verta($Vehicle->created_at)->format('Y-m-d H:i:s') }}
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
            integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>

    <script>
        document.getElementById('membership_fee').addEventListener('input', function(event) {
            let value = event.target.value.replace(/,/g, ''); // Remove existing commas
            if (!isNaN(value) && value !== '') {
                value = Number(value).toLocaleString('en-US');
                event.target.value = value;
            } else {
                event.target.value = '';
            }
        });
    </script>

    <script>
        function showFields() {
            var vehicleType = document.getElementById('vehicle-type').value;
            var motorField = document.getElementById('motor-field');
            var carFields = document.getElementById('car-fields');
            var motorDetails = document.getElementById('motor_pelak');
            var platePart1 = document.getElementById('plate-part1');
            var platePart2 = document.getElementById('plate-part2');
            var platePart3 = document.getElementById('plate-part3');
            var platePart4 = document.getElementById('plate-part4');

            motorField.style.display = 'none';
            carFields.style.display = 'none';

            if (vehicleType === '1') {
                motorField.style.display = 'block';
                carFields.style.display = 'none';
                platePart1.value = '';
                platePart2.value = '';
                platePart3.value = '';
                platePart4.value = '';
                motorDetails.required = true;
                platePart1.required = false;
                platePart2.required = false;
                platePart3.required = false;
                platePart4.required = false;
            } else if (vehicleType === '0') {
                carFields.style.display = 'block';
                motorField.style.display = 'none';
                motorDetails.value = '';
                motorDetails.required = false;
                platePart1.required = true;
                platePart2.required = true;
                platePart3.required = true;
                platePart4.required = true;
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            showFields();
        });
    </script>

    <script src="{{ asset('modules/core/js/title-to-slug.js') }}"></script>

    <script>

        function addFormElements(current) {
            let newForm =   $(current).parents('.form-list').append($(current).parents('.form-row').clone())
            let eles =   document.getElementsByClassName('new-image');
            var i = 0;
            for (let item of eles){
                item.id = 'image'+ i
                i++
            }
        }
    </script>
@endsection

