@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.Vehicle.index')}}" method="get"  target="_blank">
                                    <div class="row">
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت</label>
                                            <select id="selectpickerSelectDeselect" name="state[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                <option value="accepted">تایید شده</option>
                                                <option value="rejected">رد شده</option>
                                                <option value="pending">درحال بررسی</option>
                                            </select>
                                        </div>
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">مدل</label>
                                            <input type="number" id="model_year"  name="model_year" class="form-control" placeholder="مدل" value="{{ old('model_year') }}">
                                        </div>
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی</label>
                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}">{{ $category->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">برند</label>
                                            <select id="selectpickerSelectDeselect" name="brands[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($brands as $brand)
                                                    <option value="{{ $brand->id }}">{{ $brand->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">تیپ</label>
                                            <select id="selectpickerSelectDeselect" name="types[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($types as $type)
                                                    <option value="{{ $type->id }}">{{ $type->title }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-3">
                                            <label for="selectpickerSelectDeselect" class="form-label">کاربر</label>
                                            <select id="selectpickerSelectDeselect" name="users[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($users as $user)
                                                    <option value="{{ $user->id }}">{{ $user->profile->first_name . '-' . $user->mobile }}</option>
                                                @endforeach
                                            </select>
                                        </div>

{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($categories as $category)--}}
{{--                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category])--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}

{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">نوع خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="type_id[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($types as $type)--}}
{{--                                                    <option value="{{$type->id}}">{{$type->title}}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}

{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">منابع خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="source_id[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                @foreach($sources as $source)--}}
{{--                                                    <option value="{{$source->id}}">{{$source->title}}</option>--}}
{{--                                                @endforeach--}}
{{--                                            </select>--}}
{{--                                        </div>--}}

{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">وضعیت خبر</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="state[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                <option value="1">فعال</option>--}}
{{--                                                <option value="0">غیر فعال</option>--}}
{{--                                            </select>--}}
{{--                                        </div>--}}

{{--                                        <div class="col-3">--}}
{{--                                            <label for="selectpickerSelectDeselect" class="form-label">ویژه</label>--}}
{{--                                            <select id="selectpickerSelectDeselect" name="special[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">--}}
{{--                                                <option value="1">ویژه</option>--}}
{{--                                                <option value="0">غیر ویژه</option>--}}
{{--                                            </select>--}}
{{--                                        </div>--}}


{{--                                        <div class="col-2">--}}
{{--                                            <label for="flatpickr-datetime" class="form-label">از تاریخ</label>--}}
{{--                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="start_date" id="publish_up" />--}}
{{--                                        </div>--}}

{{--                                        <div class="col-2">--}}
{{--                                            <label for="flatpickr-datetime" class="form-label">تا تاریخ</label>--}}
{{--                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="end_date" id="publish_down" />--}}
{{--                                        </div>--}}



                                        <div class="row" style="margin-top: 20px;">
                                            <div class="col-md-12">
                                                <div class="row" style="justify-content: center;">
                                                    <div class="col-md-1">
                                                        <button name="filter" type="submit" class="btn btn-primary me-1">جستجو</button>
                                                    </div>
{{--                                                    <div class="col-md-1">--}}
{{--                                                        <button name="print" type="submit" class="btn btn-warning me-1">پرینت</button>--}}
{{--                                                    </div>--}}

                                                    <div class="col-md-1">
                                                        <button name="excel" type="submit" class="btn btn-success me-1">اکسل</button>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <button name="pdf" type="submit" class="btn btn-danger me-1">پی دی اف</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>

    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.Vehicle') }}" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.Vehicle.create') }}" role="button"
                   aria-expanded="false">جدید</a>
{{--                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>--}}
{{--                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>--}}
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("وسایل نقلیه")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>ماشین</th>
                    <th>مالک</th>
                    <th>پایان بیمه نامه</th>
                    <th>ایجاد</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($Vehicles as $Vehicle)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $Vehicle->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            <a style="color: blue" href="{{route('admin.Vehicle.index')}}">
                                <b class="active">{{ $Vehicle->brand->title }}  {{ " مدل ".$Vehicle->model_year }}  {{ "تیپ ".$Vehicle->type->title }}</b>
                            </a>
                        </td>
                        <td>
                            <a href="{{ route('admin.user.edit', $Vehicle->user->id) }}">
                                {{ $Vehicle->user->profile->first_name }}</a>
                        </td>

                        <td>
                                {{ Verta($Vehicle->insurance_date)->format('Y-m-d H:i:s') }}
                        </td>

                        <td>
                            @if ($Vehicle->created_at != null)
                                {{ Verta($Vehicle->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            @if ($Vehicle->state == 'accepted')
                                <span class="badge bg-success">تایید شده</span>
                            @elseif($Vehicle->state == 'rejected')
                                <span class="badge bg-danger">رد شده</span>
                            @elseif($Vehicle->state == 'pending')
                                <span class="badge bg-warning">نیاز به بررسی</span>
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.Vehicle.edit', $Vehicle->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i>بررسی و ویرایش</a>

                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $Vehicle->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $Vehicle->id }}"
                                          action="{{ route('admin.Vehicle.destroy', $Vehicle->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{--                {{ $educations->render() }}--}}
            </div>
        </div>
    </div>
@endsection
