@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')

@endsection

@section('script')
    <script>
        document.getElementById('membership_fee').addEventListener('input', function (e) {
            // حذف کاراکترهای غیر عددی
            let value = e.target.value.replace(/,/g, '');
            // جدا کردن اعداد هر ۳ رقم
            value = value.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
            e.target.value = value;
        });
    </script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>
        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.education.list','news')}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <x-modal id="add" size="sm" header="ثبت دسته بندی وسیله نقلیه">
            <form id="formData" action="{{ route('admin.VehicleCategory.store') }}" method="post">
                {{ csrf_field() }}

                <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="title">عنوان</label>
                                    <input type="text" id="title" name="title" class="form-control"
                                           placeholder="عنوان" value="">
                                    @if ($errors->has('title'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="membership_fee">هزینه حق عضویت</label>
                                    <input type="text" id="membership_fee" name="membership_fee" class="form-control"
                                           placeholder="هزینه حق عضویت" value="">
                                    @if ($errors->has('membership_fee'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('membership_fee') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                        <span>*</span>
                                        <label class="form-label" for="state">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="state" name="state" class="form-select">
                                                <option value="1" {{ '1' == old('state') ? 'selected' : '' }}>فعال
                                                </option>
                                                <option value="0" {{ '0' == old('state') ? 'selected' : '' }}>غیر
                                                    فعال</option>
                                            </select>
                                        </div>
                                </div>
                                <div class="col-md-6">
                                <span>*</span>
                                <label class="form-label" for="state">نوع</label>
                                <div class="position-relative">
                                    <select id="state" name="type" class="form-select">
                                        <option value="1" {{ '1' == old('type') ? 'selected' : '' }}>موتور
                                        </option>
                                        <option value="0" {{ '0' == old('type') ? 'selected' : '' }}>اتوموبیل</option>
                                    </select>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                    <a href="{{ route('admin.VehicleCategory.index') }}" type="reset"
                       class="btn btn-label-secondary">انصراف</a>
                </div>
            </form>
        </x-modal>
        <form action="{{ route('admin.bulk.VehicleCategories') }}" method="get">
            <p class="demo-inline-spacing">
{{--                <a class="btn btn-primary me-1" href="{{ route('admin.VehicleCategory.create') }}" role="button"--}}
{{--                   aria-expanded="false">جدید</a>--}}
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#add">
                    جدید
                </button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>

            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("دسته بندی وسایل نقلیه")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>نوع</th>
                    <th>هزینه حق عضویت</th>
                    <th>ایجاد</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($VehicleCategories as $VehicleCategory)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $VehicleCategory->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            @if($VehicleCategory->state == 0)
                                <a style="color: red" href="{{route('admin.VehicleCategory.index')}}">
                                    <b class="active">{{ $VehicleCategory->id }} -
                                        {{ $VehicleCategory->title }}</b>
                                </a>
                            @else
                                <a style="color: blue" href="{{route('admin.VehicleCategory.index')}}">
                                    <b class="active">{{ $VehicleCategory->id }} -
                                        {{ $VehicleCategory->title }}</b>
                                </a>
                            @endif
                        </td>
                        <td>
                            @if($VehicleCategory->type == 0)
                                اتوموبیل
                            @elseif($VehicleCategory->type == 1)
                                موتور
                            @endif
                        </td>

                        <td>
                            {{ number_format($VehicleCategory->membership_fee)}}
                        </td>

                        <td>
                            @if ($VehicleCategory->created_at != null)
                                {{ Verta($VehicleCategory->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
{{--                                    <a class="dropdown-item" href="{{ route('admin.VehicleCategory.edit', $VehicleCategory->id) }}"><i--}}
{{--                                            class="bx bx-edit-alt me-1"></i>ویرایش</a>--}}

                                    <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit_vehicleCategory-{{$VehicleCategory->id }}">
                                        <i class="bx bx-edit-alt me-1"></i>ویرایش
                                    </button>
                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $VehicleCategory->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $VehicleCategory->id }}"
                                          action="{{ route('admin.VehicleCategory.destroy', $VehicleCategory->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>

                    {{--                    @include('user::Dashboard.Frest.education._partial', [--}}
                    {{--                        'education' => $education,--}}
                    {{--                        'row' => 0,--}}
                    {{--                    ])--}}
                @endforeach

                @foreach ($VehicleCategories as $VehicleCategory)
                    <x-modal id="edit_vehicleCategory-{{$VehicleCategory->id}}" size="sm" header="ویرایش دسته بندی وسیله نقلیه">
                        <form id="formData" action="{{ route('admin.VehicleCategory.update', $VehicleCategory->id) }}" method="post">
                            {{ csrf_field() }}
                            @method('patch')

                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">عنوان</label>
                                                <input type="text" id="title" name="title" class="form-control"
                                                       placeholder="عنوان" value="{{$VehicleCategory->title}}">
                                                @if ($errors->has('title'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">هزینه حق عضویت</label>
                                                <input type="text" id="membership_fee" name="membership_fee" class="form-control"
                                                       placeholder="کلید" value="{{ number_format($VehicleCategory->membership_fee) }}">
                                                @if ($errors->has('membership_fee'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('membership_fee') }}
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="state">وضعیت</label>
                                                <div class="position-relative">
                                                    <select id="state" name="state" class="form-select">
                                                        @if($VehicleCategory->state == 1)
                                                            <option value="1" selected>فعال</option>
                                                            <option value="0">غیر فعال</option>
                                                        @else
                                                            <option value="1">فعال</option>
                                                            <option value="0" selected>غیر فعال</option>
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="state">نوع</label>
                                                <div class="position-relative">
                                                    <select id="state" name="type" class="form-select">
                                                        @if($VehicleCategory->type == 0)
                                                            <option value="0" selected>اتوموبیل</option>
                                                            <option value="1">موتور</option>
                                                        @else
                                                            <option value="1" selected>موتور</option>
                                                            <option value="0">اتوموبیل</option>
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.VehicleCategory.index') }}" type="reset"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </x-modal>
                @endforeach
                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{--                {{ $educations->render() }}--}}
            </div>
        </div>
    </div>
@endsection
