@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

@section('style')
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
@endsection

@section('script')


    <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

    <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

    <script>
        var options = {
            filebrowserImageBrowseUrl: '/file-manager/ckeditor',
        };
        CKEDITOR.replace('body' ,options);
        $('#submit').on('keyup keypress', function(e) {
            var keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });
    </script>

    <script>

        const tag1 = document.querySelector("#tag");
        const tag = new Tagify(tag1, {
            {{--whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],--}}
            dropdown: {
                classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                enabled: 0,             // <- show suggestions on focus
                closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected
            }
        });
    </script>

@endsection

@section('content')

    @include('core::components.file_set_to_editor')

    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                                تیپ وسایل نقلیه
                            </button>
                        </li>
                        {{--                        @foreach($field_groups->where('type','products') as $group)--}}

                        {{--                            <li class="nav-item">--}}
                        {{--                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#{{$group->name}}" role="tab" aria-selected="true">--}}
                        {{--                                    {{$group->title}}--}}
                        {{--                                </button>--}}
                        {{--                            </li>--}}


                        {{--                        @endforeach--}}
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" action="{{route('admin.VehicleType.update',$VehicleType->id)}}" method="post">
                        {{ csrf_field() }}
                        @method('patch')
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title" name="title" class="form-control"
                                                   placeholder="عنوان" value="{{$VehicleType->title}}">
                                            @if ($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                                </div>
                                            @endif
                                        </div>

                                        <div class="col-md-3">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select id="state" name="state" class="form-select">
                                                    @if($VehicleType->state == 1)
                                                        <option value="1" selected>فعال
                                                        </option>
                                                        <option value="0">غیر
                                                            فعال</option>
                                                    @else
                                                        <option value="1" selected>فعال
                                                        </option>
                                                        <option value="0" selected>غیر
                                                            فعال</option>
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <span>*</span>
                                            <label class="form-label" for="brand">برند</label>
                                            <div class="position-relative">
                                                <select id="brand_id" name="brand_id" class="form-select">
                                                    @foreach($VehicleBrands as $VehicleBrand)
                                                        @if($VehicleBrand->id == $selectedBrand)
                                                            <option selected value="{{ $VehicleBrand->id }}">{{ $VehicleBrand->title }}</option>
                                                        @else
                                                            <option value="{{ $VehicleBrand->id }}">{{ $VehicleBrand->title }}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.VehicleType.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="{{ asset('modules/core/js/slug-edit.js') }}"></script>

@endsection
