@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.education.list','news')}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <x-modal id="add" size="sm" header=" تیپ وسیله نقلیه">
            <form id="formData" action="{{ route('admin.VehicleType.store') }}" method="post">
                {{ csrf_field() }}

                <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-6">
                                        <span>*</span>
                                        <label class="form-label" for="title">عنوان</label>
                                        <input type="text" id="title" name="title" class="form-control"
                                               placeholder="عنوان" value="">
                                        @if ($errors->has('title'))
                                            <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                            </div>
                                        @endif
                                    </div>
                                <div class="col-md-6">
                                    {{--                                            <span>*</span>--}}
                                    <label class="form-label" for="brand">برند</label>
                                    <div class="position-relative">
                                        <select id="brand_id" name="brand_id" class="form-select">                                      \
                                            <option value="">انتخاب کنید</option>
                                            @foreach($VehicleBrands as $VehicleBrand)
                                                <option value="{{ $VehicleBrand->id }}">{{ $VehicleBrand->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="state">وضعیت</label>
                                    <div class="position-relative">
                                        <select id="state" name="state" class="form-select">
                                            <option value="1" {{ '1' == old('state') ? 'selected' : '' }}>فعال
                                            </option>
                                            <option value="0" {{ '0' == old('state') ? 'selected' : '' }}>غیر
                                                فعال</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                    <a href="{{ route('admin.VehicleType.index') }}" type="reset"
                       class="btn btn-label-secondary">انصراف</a>
                </div>
            </form>
        </x-modal>
        <form action="{{ route('admin.bulk.VehicleTypes') }}" method="get">
            <p class="demo-inline-spacing">
{{--                <a class="btn btn-primary me-1" href="{{ route('admin.VehicleType.create') }}" role="button"--}}
{{--                   aria-expanded="false">جدید</a>--}}
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#add">
                    جدید
                </button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard(" تیپ وسایل نقلیه")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>عنوان</th>
                    <th>ایجاد</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($brandTypes as $brandType)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $brandType->type->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            @if($brandType->type->state == 0)
                                <a style="color: red" href="{{route('admin.VehicleType.index')}}">
                                    <b class="active">
{{--                                        {{ $brandType->type->id }} ---}}
                                        {{   $brandType->brand->title . ' تیپ ' . $brandType->type->title }}</b>
                                </a>
                            @else
                                <a style="color: blue" href="{{route('admin.VehicleType.index')}}">
                                    <b class="active">
{{--                                        {{ $brandType->type->id }} ---}}
                                        {{   $brandType->brand->title . ' تیپ ' . $brandType->type->title }}</b>
                                </a>
                            @endif
                        </td>

                        <td>
                            @if ($brandType->type->created_at != null)
                                {{ Verta($brandType->type->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.VehicleType.edit', $brandType->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i>ویرایش</a>

{{--                                    <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit_vehicleType-{{$brandType->id }}">--}}
{{--                                        <i class="bx bx-edit-alt me-1"></i>ویرایش--}}
{{--                                    </button>--}}
                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $brandType->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $brandType->id }}"
                                          action="{{ route('admin.VehicleType.destroy', $brandType->type->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>

                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{--                {{ $educations->render() }}--}}
            </div>
        </div>
    </div>
@endsection
