<!doctype html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>

    <style>
        body {
            font-family: 'aviny';
            direction: rtl;
            text-align: right;
        }
    </style>
</head>
<body>
    <table>
    <thead>
    <tr>
        <th>ماشین</th>
        <th>مالک</th>
        <th>پایان بیمه نامه</th>
        <th>ایجاد</th>
        <th>وضعیت</th>
    </tr>
    </thead>
    <tbody>

    @foreach ($Vehicles as $Vehicle)
        <tr>
            <td>
                <a style="color: blue" href="{{route('admin.Vehicle.index')}}">
                    <b>{{ $Vehicle->brand->title }}  {{ " مدل ".$Vehicle->model_year }}  {{ "تیپ ".$Vehicle->type->title }}</b>
                </a>
            </td>
            <td>
                <a href="{{ route('admin.user.edit', $Vehicle->user->id) }}">
                    {{ $Vehicle->user->profile->first_name }}</a>
            </td>

            <td>
                {{ Verta($Vehicle->insurance_date)->format('Y-m-d H:i:s') }}
            </td>

            <td>
                @if ($Vehicle->created_at != null)
                    {{ Verta($Vehicle->created_at)->format('Y-m-d H:i:s') }}
                @endif
            </td>

            <td>
                @if ($Vehicle->state == 'accepted')
                    <span>تایید شده</span>
                @elseif($Vehicle->state == 'rejected')
                    <span>رد شده</span>
                @elseif($Vehicle->state == 'pending')
                    <span>نیاز به بررسی</span>
                @endif
            </td>
        </tr>
    @endforeach

    </tbody>
</table>
</body>
</html>
