<?php
Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('VehicleCategory','VehicleCategoryController');
    Route::get('VehicleCategory/index','VehicleCategoryController@index')->name('VehicleCategory.list');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/VehicleCategory','VehicleCategoryController@bulkAction')->name('VehicleCategories');
    });
});

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('VehicleBrand','VehicleBrandController');
    Route::get('VehicleBrand/index','VehicleBrandController@index')->name('VehicleBrand.list');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/VehicleBrand','VehicleBrandController@bulkAction')->name('VehicleBrands');
    });
});

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('VehicleType','VehicleTypeController');
    Route::get('VehicleType/index','VehicleTypeController@index')->name('VehicleType.list');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/VehicleType','VehicleTypeController@bulkAction')->name('VehicleTypes');
    });
});

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('Vehicle','VehicleController');
    Route::get('Vehicle/index','VehicleController@index')->name('Vehicle.list');
    Route::post('Vehicle/create/note/{id}','VehicleController@createNote')->name('Vehicle.create.note');
//    Route::get('Vehicle/show/{$id}','VehicleController@show_gallery')->name('Vehicle.gallery');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/Vehicle','VehicleController@bulkAction')->name('Vehicle');
    });
});


