<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;
use Nwidart\Modules\Facades\Module;

class PublishAssetModule extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nodad:publish-asset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Publish Modules Asset.';

    /**
     * Execute the console command.
     */
    public function __construct(Filesystem $filesystem)
    {
        parent::__construct();
        $this->filesystem = $filesystem;
    }

    public function handle()
    {

        $modules = Module::all();

        foreach ($modules as $module) {
            $folderPath = base_path("Modules/".$module->getName()."/resources/assets");


            $shortcutPath = public_path("modules");

            if(is_dir($shortcutPath) == false){
                $this->filesystem->makeDirectory(public_path('modules'));
            }

            $shortcutPath = public_path("modules/".strtolower($module->getName()));

            $this->filesystem->link($folderPath, $shortcutPath);
            $this->info('Shortcut created successfully.');
        }

    }

}
