<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class ListCategory extends Component
{

    public $categories = [];
    public $selectLanguage = null;
    public $model = null;
    public $cat_id = null;
    public $type = null;
    public $lang = null;

    public function loadCategories() {

        $user = Auth::guard('admin')->user();


            $this->categories = \Modules\Category\Entities\Category::
           whereType('news')->whereState(1)
                ->whereHas('roles', function ($query)  use ($user) {
                    $query->whereIn('id',$user->roles->pluck('role_id'));
                })->whereNull('parent_id')->get();



    }
    public function render()
    {
        $categories = $this->categories;
        return view('category::Dashboard.Frest.category.Component.categories',compact('categories'));
    }
}
