<?php

namespace App\Observers;




use Modules\Counseling\Entities\CounselingMonth;
use Modules\Counseling\Entities\CounselingYear;

class CounselingYearObserver
{
    /**
     * Handle the Counseling "created" event.
     *
     * @param  \App\Models\Counseling  $counseling
     * @return void
     */
    public function created(CounselingYear $counseling)
    {
        $monthes = [
            'فروردین',
            'اردیبهشت',
            'خرداد',
            'تیر',
            'مرداد',
            'شهریور',
            'مهر',
            'آبان',
            'آذر',
            'دی',
            'بهمن',
            'اسفند',
        ];

        foreach ($monthes as $month){
            CounselingMonth::create([
                'month' => $month,
                'yearId' => $counseling->id
            ]);
        }



    }


}
