<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */

    public const HOME = '/admin/panel';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {

        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

   try{
            $admin_template_name = 'frest';
            $site_template_name = '';
            if(DB::connection()->table('templates')->exists()){
                if (Schema::hasTable('templates')) {

                    $admin_template = DB::table('templates')->where('type','admin')->where('state',1)->first();
                    $site_template = DB::table('templates')->where('type','site')->where('state',1)->first();

                    if($admin_template == null) {
                        $admin_template = DB::table('templates')->where('type','admin')->first();
                    }

                    if($site_template == null) {
                        $site_template = DB::table('templates')->where('type','site')->first();
                    }

                    if($admin_template != null) {
                        $admin_template_name = $admin_template->name;
                    }

                    if($site_template != null) {
                        $site_template_name = $site_template->name;
                    }

                }

            }
        }catch (\Exception $e){

        }



        Config::set('app.template_admin_route',$admin_template_name);
        Config::set('app.template_admin',$admin_template_name);

        Config::set('app.template_site_route',$site_template_name);
        Config::set('app.template_site',$site_template_name);


        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });
    }
}
