<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Admin\app\Models\Admin;
use Modules\Language\app\Models\Language;
use Modules\Role\app\Models\Permission;
use Modules\Role\app\Models\PermissionGroup;
use Modules\Role\app\Models\Role;
use Modules\Site\app\Models\Site;
use Modules\Template\app\Models\Template;

class InitialDataBaseTableSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $group = PermissionGroup::firstOrCreate(
            ['title' => 'مجموعه ها', 'name' => 'category'],
            ['title' => 'مجموعه ها', 'name' => 'category']
        );


        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'category.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'category.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'category.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'category.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'category.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'category.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'category.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'category.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'کاتالوگ', 'name' => 'magazine'],
            ['title' => 'کاتالوگ', 'name' => 'magazine']
        );


        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'magazine.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'magazine.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'magazine.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'magazine.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'magazine.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'magazine.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'magazine.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'magazine.edit','group' => $group->name]
        );






        $group = PermissionGroup::firstOrCreate(
            ['title' => 'نظرسنجی', 'name' => 'poll'],
            ['title' => 'نظرسنجی', 'name' => 'poll']
        );


        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'poll.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'poll.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'poll.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'poll.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'poll.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'poll.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'poll.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'poll.edit','group' => $group->name]
        );




        $group = PermissionGroup::firstOrCreate(
            ['title' => 'منابع خبر', 'name' => 'source'],
            ['title' => 'منابع خبر', 'name' => 'source']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'source.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'source.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'source.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'source.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'source.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'source.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'source.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'source.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'صفحات', 'name' => 'page'],
            ['title' => 'صفحات', 'name' => 'page']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'page.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'page.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'page.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'page.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'page.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'page.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'page.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'page.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'تبلیغات', 'name' => 'ads'],
            ['title' => 'تبلیغات', 'name' => 'ads']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'ads.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'ads.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'ads.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'ads.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'ads.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'ads.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'ads.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'ads.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'نوع خبر', 'name' => 'type'],
            ['title' => 'نوع خبر', 'name' => 'type']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'type.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'type.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'type.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'type.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'type.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'type.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'type.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'type.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'خبر', 'name' => 'news'],
            ['title' => 'خبر', 'name' => 'news']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'news.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'news.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'news.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'news.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'news.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'news.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'news.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'news.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'قسمت منو ها', 'name' => 'menu'],
            ['title' => 'قسمت منو ها', 'name' => 'menu']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'menu.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'menu.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'menu.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'menu.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'menu.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'menu.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'menu.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'menu.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'دسترسی مدیران', 'name' => 'admin'],
            ['title' => 'دسترسی مدیران', 'name' => 'admin']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'admin.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'admin.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'admin.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'admin.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'admin.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'admin.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'admin.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'admin.edit','group' => $group->name]
        );

        $group = PermissionGroup::firstOrCreate(
            ['title' => 'نظر دوستان', 'name' => 'perspective'],
            ['title' => 'نظر دوستان', 'name' => 'perspective']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'perspective.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'perspective.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'perspective.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'perspective.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'perspective.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'perspective.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'perspective.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'perspective.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'سوالات متداول', 'name' => 'question'],
            ['title' => 'سوالات متداول', 'name' => 'question']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'question.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'question.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'question.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'question.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'question.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'question.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'question.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'question.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'ویدئوها', 'name' => 'video'],
            ['title' => 'ویدئوها', 'name' => 'video']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'video.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'video.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'video.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'video.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'video.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'video.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'video.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'video.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'آلبوم ها', 'name' => 'album'],
            ['title' => 'آلبوم ها', 'name' => 'album']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'album.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'album.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'album.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'album.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'album.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'album.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'album.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'album.edit','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'محصولات', 'name' => 'product'],
            ['title' => 'محصولات', 'name' => 'product']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'product.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'product.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => ' ایجاد', 'key' => 'product.create','group' => $group->name],
            ['title' => ' ایجاد', 'key' => 'product.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'product.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'product.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'product.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'product.edit','group' => $group->name]
        );







        $group = PermissionGroup::firstOrCreate(
            ['title' => 'کاربران', 'name' => 'user'],
            ['title' => 'کاربران', 'name' => 'user']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'user.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'user.access','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ایجاد', 'key' => 'user.create','group' => $group->name],
            ['title' => 'ایجاد', 'key' => 'user.create','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'user.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'user.delete','group' => $group->name]
        );
        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'user.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'user.edit','group' => $group->name]
        );

        $group = PermissionGroup::firstOrCreate(
            ['title' => 'نظرات', 'name' => 'comment'],
            ['title' => 'نظرات', 'name' => 'comment']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'comment.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'comment.access','group' => $group->name]
        );

        $group = PermissionGroup::firstOrCreate(
            ['title' => 'تماس با ما', 'name' => 'contact'],
            ['title' => 'تماس با ما', 'name' => 'contact']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'contact.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'contact.access','group' => $group->name]
        );

        $group = PermissionGroup::firstOrCreate(
            ['title' => 'قالب ها', 'name' => 'template'],
            ['title' => 'قالب ها', 'name' => 'template']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'template.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'template.access','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'ایجاد', 'key' => 'template.create','group' => $group->name],
            ['title' => 'ایجاد', 'key' => 'template.create','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'template.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'template.edit','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'template.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'template.delete','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'مالی', 'name' => 'invoice'],
            ['title' => 'مالی', 'name' => 'invoice']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'invoice.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'invoice.access','group' => $group->name]
        );


        $group = PermissionGroup::firstOrCreate(
            ['title' => 'تنظیمات سایت', 'name' => 'site'],
            ['title' => 'تنظیمات سایت', 'name' => 'site']
        );

        Permission::firstOrCreate(
            ['title' => 'دسترسی', 'key' => 'controlpanel.access','group' => $group->name],
            ['title' => 'دسترسی', 'key' => 'controlpanel.access','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'ایجاد', 'key' => 'controlpanel.create','group' => $group->name],
            ['title' => 'ایجاد', 'key' => 'controlpanel.create','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'ویرایش', 'key' => 'controlpanel.edit','group' => $group->name],
            ['title' => 'ویرایش', 'key' => 'controlpanel.edit','group' => $group->name]
        );

        Permission::firstOrCreate(
            ['title' => 'حذف', 'key' => 'controlpanel.delete','group' => $group->name],
            ['title' => 'حذف', 'key' => 'controlpanel.delete','group' => $group->name]
        );

















        Site::firstOrCreate(
            ['title' => 'سایت تستی'],
            [
                'title' => 'سایت تستی',
                'state' => 1,
            ]);


        $role = Role::firstOrCreate(
            ['key' => 'admin'],
            ['title' => 'مدیر اصلی','key' => 'admin','image' => '','desc' => '','state' => 1]);


        Template::firstOrCreate(
            ['name' => 'frest','type' => 'admin'],
            ['title' => 'قالب ادمین', 'name' => 'frest','type' => 'admin']);

        Template::firstOrCreate(
            ['name' => 'borhan','type' => 'site'],
            ['title' => 'قالب برهان', 'name' => 'borhan','type' => 'site']);

        $permissions = Permission::all()->pluck('id')->toArray();


        $role->permissions()->sync($permissions);

        $admin =  Admin::firstOrCreate(
            [
                'mobile' => '09110000000',
            ],
            [
                'name' => 'مدیر',
                'mobile' => '09110000000',
                'send_sms' => 0,
                'username' => 'admin',
                'type' => 'admin',
                'state' => 1,
                'password' => bcrypt('123456789'),
            ]
        );

        $admin->roles()->create([
            'role_id' => $role->id,
        ]);

        $admin2 =  Admin::firstOrCreate(
            [
                'mobile' => '09110000001',
            ],
            [
                'name' => 'مدیر2',
                'mobile' => '09110000001',
                'send_sms' => 0,
                'username' => 'admin3',
                'type' => 'admin',
                'state' => 1,
                'password' => bcrypt('123456789'),
            ]
        );

        $admin2->roles()->create([
            'role_id' => $role->id,
        ]);


        Language::firstOrCreate(['title' => 'فارسی','name' => 'fa'],['title' => 'فارسی','name' => 'fa']);
        Language::firstOrCreate(['title' => 'انگلیسی','name' => 'fa'],['title' => 'انگلیسی','name' => 'en']);
        Language::firstOrCreate(['title' => 'عربی','name' => 'ar'],['title' => 'عربی','name' => 'ar']);

    }
}
