<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صفحه 404 - یافت نشد</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background: #000;
            color: #ffcc00;
            font-family: 'Tahoma', sans-serif;
            text-align: center;
        }

        .container {
            max-width: 600px;
            padding: 20px;
            border: 2px solid #ffcc00;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(255, 204, 0, 0.5);
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            animation: fadeIn 1.2s ease-in-out;
        }

        h1 {
            font-size: 100px;
            margin: 0;
            font-weight: bold;
            text-shadow: 2px 4px rgba(0, 0, 0, 0.5);
        }

        p {
            font-size: 18px;
            margin: 20px 0;
            line-height: 1.6;
            text-shadow: 1px 2px rgba(0, 0, 0, 0.3);
        }

        a {
            display: inline-block;
            padding: 10px 25px;
            margin-top: 15px;
            background: #ffcc00;
            color: #000;
            border-radius: 25px;
            text-decoration: none;
            font-size: 16px;
            font-weight: bold;
            box-shadow: 0 5px 15px rgba(255, 204, 0, 0.5);
            transition: all 0.3s ease-in-out;
        }

        a:hover {
            background: #000;
            color: #ffcc00;
            border: 1px solid #ffcc00;
            box-shadow: 0 7px 20px rgba(255, 204, 0, 0.7);
            transform: scale(1.05);
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>404</h1>
    <p>متأسفیم، صفحه‌ای که دنبال آن هستید وجود ندارد!</p>
    <a href="/">بازگشت به صفحه اصلی</a>
</div>
</body>
</html>
